/*
 * Decompiled with CFR 0.152.
 */
package azmalent.cuneiform.filter;

import azmalent.cuneiform.filter.FilteringUtil;
import java.util.logging.Filter;
import java.util.logging.LogRecord;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.filter.AbstractFilter;

class LogFilter
extends AbstractFilter
implements Filter {
    LogFilter() {
    }

    public Filter.Result filter(LogEvent event) {
        String line = String.format("[%s]: %s", event.getLoggerName(), event.getMessage().getFormattedMessage());
        boolean isLoggable = FilteringUtil.isLoggable(line);
        if (isLoggable) {
            Throwable exception = event.getThrown();
            FilteringUtil.truncateException(exception);
        }
        return isLoggable ? Filter.Result.NEUTRAL : Filter.Result.DENY;
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        String line = String.format("[%s]: %s", record.getLoggerName(), record.getMessage());
        boolean isLoggable = FilteringUtil.isLoggable(line);
        if (isLoggable) {
            Throwable exception = record.getThrown();
            FilteringUtil.truncateException(exception);
        }
        return isLoggable;
    }
}

